
function loadHistory(){
  const key='vc_results'; const all=JSON.parse(localStorage.getItem(key)||'[]');
  const tbody=document.querySelector('#resultsTable tbody'); tbody.innerHTML='';
  for(const r of all){
    const tr=document.createElement('tr');
    const d=new Date(r.t); const dateStr=d.toLocaleString();
    tr.innerHTML = `<td>${dateStr}</td><td>${Math.round(r.ping)} ms</td><td>${r.dl.toFixed(1)}</td><td>${r.ul.toFixed(1)}</td><td><span class="badge">${r.server}</span></td>`;
    tbody.appendChild(tr);
  }
}
document.getElementById('clearHistory').addEventListener('click', ()=>{ localStorage.removeItem('vc_results'); loadHistory(); });
loadHistory();
